<?php 
/*
Plugin Name: MJJ BBP Menu Order Update
Plugin URI: http://emptywaterbottles.com
Description: recalculates menu_order in a wp_posts for a given topic
Author: Mary (JJ) Jay
Author URI: http://emptywaterbottles.com
Version: 0.1
*/

class MJJBBPUpdateReplyPosition{

	function __construct() {
		add_action( 'admin_menu', array( $this, 'mjj_bbp_update_reply_position_page' ) );
	}
	
	//add the admin page to users http://codex.wordpress.org/Creating_Options_Pages
	public function mjj_bbp_update_reply_position_page()
	   {
	       // This page will be under "Settings"
	       add_management_page(
	           'MJJ BBP Update Reply Position', 
	           'MJJ BBP Update Reply Position', 
	           'manage_options', 
	           'mjj-bbp-update-reply-position', 
	           array( $this, 'create_admin_page' )
	       );
	   }
	   
	//creates the view page in admin
	public function create_admin_page()
	    { ?>
	        <div id="mjj-updatable" class="wrap">
	            
	            
	            <?php 
	           		
	            	//Marlene Dietrich
	            	screen_icon(); ?>
	            
	            <h2>Update menu_order if your permalinks have gone off</h2> 
	            
	            <form action="" class="updatable" method="post">
	            	<label>Put in the topic id of the confused topic</label>
	            	<input type="number" name="topic_id" value="" />
	            	<input type="submit" value="submit" /> 
	            
	            </form>
	            
	            <?php 
	            if( current_user_can( 'manage_options' ) && isset( $_POST['topic_id'] ) && !empty( $_POST['topic_id'] ) ){
	            	$topic_id = $_POST['topic_id'];
	            	$clean_topic_id = absint( $topic_id );
	            	echo '<h2>The results: </h2>';
	            	mjj_bbp_update_reply_position( $clean_topic_id );
	            }
	            ?>
	            	
	            
	       </div>

	<?php }
}

new MJJBBPUpdateReplyPosition();


function mjj_bbp_update_reply_position( $topic_id ) {
	
	$args = array(
		'orderby' => 'date',
		'order' => 'ASC',
		'post_parent' => $topic_id,
		'post_type' => 'reply'
	);
	$reply_array = get_children( $args );
	// Bail if reply_id is empty
	foreach( $reply_array as $reply ){
		$reply_id = bbp_get_reply_id( $reply->ID );
		if ( empty( $reply_id ) ){

			return false;
		}

		// No if statement here - do them all
		
		$reply_position = bbp_get_reply_position_raw( $reply_id, bbp_get_reply_topic_id( $reply_id ) );
		

	// Update the replies' 'menp_order' with the reply position
	wp_update_post( array(
		'ID'         => $reply_id,
		'menu_order' => $reply_position
	) );
	
	echo 'Post '. $reply_id . ' is now at position ' . $reply_position . '<br />';
	}
}

?>