<?php

/**
 * Implementation of vBulletin Connect v5.x Converter.
 *
 * @since bbPress (r4724)
 * @link Codex Docs http://codex.bbpress.org/import-forums/vbulletin
 */
class vBulletin5 extends BBP_Converter_Base {

	/**
	 * Main constructor
	 *
	 * @uses vBulletin5::setup_globals()
	 */
	function __construct() {
		parent::__construct();
		$this->setup_globals();
	}

	/**
	 * Sets up the field mappings
	 */
	private function setup_globals() {

		/** Forum Section *****************************************************/

		// Forum id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'nodeid',
			'from_expression' => 'WHERE node.contenttypeid = 23',
			'to_type'         => 'forum',
			'to_fieldname'    => '_bbp_forum_id'
		);

		// Forum parent id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'parentid',
			'to_type'        => 'forum',
			'to_fieldname'   => '_bbp_forum_parent_id'
		);

		// Forum topic count (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'textcount',
			'to_type'        => 'forum',
			'to_fieldname'   => '_bbp_topic_count'
		);

		// Forum reply count (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'totalcount',
			'to_type'        => 'forum',
			'to_fieldname'   => '_bbp_reply_count'
		);

		// Forum total topic count (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'textcount',
			'to_type'        => 'forum',
			'to_fieldname'   => '_bbp_total_topic_count'
		);

		// Forum total reply count (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'totalcount',
			'to_type'        => 'forum',
			'to_fieldname'   => '_bbp_total_reply_count'
		);

		// Forum title.
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'title',
			'to_type'        => 'forum',
			'to_fieldname'   => 'post_title'
		);

		// Forum slug (Clean name to avoid confilcts)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'urlident',
			'to_type'         => 'forum',
			'to_fieldname'    => 'post_name',
			'callback_method' => 'callback_slug'
		);

		// Forum description.
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'description',
			'to_type'         => 'forum',
			'to_fieldname'    => 'post_content',
			'callback_method' => 'callback_null'
		);

		// Forum display order (Starts from 1)
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'displayorder',
			'to_type'        => 'forum',
			'to_fieldname'   => 'menu_order'
		);

		// Forum dates.
		$this->field_map[] = array(
			'to_type'      => 'forum',
			'to_fieldname' => 'post_date',
			'default'      => date( 'Y-m-d H:i:s' )
		);
		$this->field_map[]	 = array(
			'to_type'      => 'forum',
			'to_fieldname' => 'post_date_gmt',
			'default'      => date( 'Y-m-d H:i:s' )
		);
		$this->field_map[]	 = array(
			'to_type'      => 'forum',
			'to_fieldname' => 'post_modified',
			'default'      => date( 'Y-m-d H:i:s' )
		);
		$this->field_map[]	 = array(
			'to_type'      => 'forum',
			'to_fieldname' => 'post_modified_gmt',
			'default'      => date( 'Y-m-d H:i:s' )
		);

		/** Topic Section *****************************************************/

		// Topic id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'topic',
			'to_fieldname'    => '_bbp_topic_id'
		);

		// Topic parent forum id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'parentid',
			'to_type'         => 'topic',
			'to_fieldname'    => '_bbp_forum_id',
			'callback_method' => 'callback_forumid'
		);

		// Topic reply count (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'totalcount',
			'to_type'         => 'topic',
			'to_fieldname'    => '_bbp_reply_count',
			'callback_method' => 'callback_topic_reply_count'
		);

		// Topic total reply count (Includes unpublished replies, Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'totalcount',
			'to_type'         => 'topic',
			'to_fieldname'    => '_bbp_total_reply_count',
			'callback_method' => 'callback_topic_reply_count'
		);

/*		// Topic hidden count (Includes unpublished replies, Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'textunpubcount',
			'to_type'         => 'topic',
			'to_fieldname'    => '_bbp_total_count_hidden',
			'callback_method' => 'callback_topic_reply_count'
		);
*/
		// Topic author.
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'userid',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_author',
			'callback_method' => 'callback_userid'
		);

		// Topic title.
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'title',
			'to_type'        => 'topic',
			'to_fieldname'   => 'post_title'
		);

		// Topic slug (Clean name to avoid conflicts)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'urlident',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_name',
			'callback_method' => 'callback_slug'
		);

		// Topic parent forum id (If no parent, then 0)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'parentid',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_parent',
			'callback_method' => 'callback_forumid'
		);

		// Topic content.
		// Note: We join the 'text' table because 'node' table does not include topic content.
		$this->field_map[] = array(
			'from_tablename'  => 'text',
			'from_fieldname'  => 'rawtext',
			'join_tablename'  => 'node',
			'join_type'       => 'INNER',
			'join_expression' => 'USING (nodeid) WHERE node.contenttypeid = 22 AND node.urlident IS NOT NULL',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_content',
			'callback_method' => 'callback_html'
		);

		// Topic dates.
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_date',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_date_gmt',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_modified',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_modified_gmt',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename' => 'node',
			'from_fieldname' => 'lastcontent',
			'to_type'        => 'topic',
			'to_fieldname'   => '_bbp_last_active_time',
			'callback_method' => 'callback_datetime'
		);

		// Topic status (Open or Closed)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'open',
			'to_type'         => 'topic',
			'to_fieldname'    => 'post_status',
			'callback_method' => 'callback_topic_status'
		);

		/** Tags Section ******************************************************/

		// Topic id.
		$this->field_map[] = array(
			'from_tablename'  => 'tagnode',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'tags',
			'to_fieldname'    => 'objectid',
			'callback_method' => 'callback_topicid'
		);

		// Taxonomy ID.
		$this->field_map[] = array(
			'from_tablename'  => 'tagnode',
			'from_fieldname'  => 'tagid',
			'to_type'         => 'tags',
			'to_fieldname'    => 'taxonomy'
		);

		// Term text.
		$this->field_map[] = array(
			'from_tablename'  => 'tag',
			'from_fieldname'  => 'tagtext',
			'join_tablename'  => 'tagnode',
			'join_type'       => 'INNER',
			'join_expression' => 'USING (tagid)',
			'to_type'         => 'tags',
			'to_fieldname'    => 'name'
		);

		/** Reply Section *****************************************************/

		// Reply id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'reply',
			'to_fieldname'    => '_bbp_vb5_reply_post_id'
		);

		// Reply id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'reply',
			'to_fieldname'    => '_bbp_post_id'
		);

		// Reply parent forum id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'parentid',
			'from_expression' => 'LEFT JOIN `node` AS `reply` ON reply.nodeid = node.nodeid
								  LEFT JOIN `node` AS `topic` ON reply.parentid = topic.nodeid
								  LEFT JOIN `node` AS `forum` ON topic.parentid = forum.nodeid',
			'to_type'         => 'reply',
			'to_fieldname'    => '_bbp_forum_id',
			'callback_method' => 'callback_topicid_to_forumid'
		);

		// Reply parent topic id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'starter',
			'to_type'         => 'reply',
			'to_fieldname'    => '_bbp_topic_id',
			'callback_method' => 'callback_topicid'
		);

		// Reply author ip (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'reply',
			'from_fieldname' => 'ipaddress',
			'to_type'        => 'reply',
			'to_fieldname'   => '_bbp_author_ip'
		);

		// Reply author.
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'userid',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_author',
			'callback_method' => 'callback_userid'
		);

		// Reply title.
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'title',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_title',
			'callback_method' => 'callback_reply_title'
		);

		// Reply slug (Clean name to avoid conflicts)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'urlident',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_title',
			'callback_method' => 'callback_slug'
		);

		// Reply content.
		// Note: We join the 'text' table because 'node' table does not include reply content.
		$this->field_map[] = array(
			'from_tablename'  => 'text',
			'from_fieldname'  => 'rawtext',
			'join_tablename'  => 'node',
			'join_type'       => 'INNER',
			'join_expression' => 'ON text.nodeid = reply.nodeid
									WHERE reply.contenttypeid =22
									AND reply.urlident IS NULL
									AND reply.title IS NOT NULL',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_content',
			'callback_method' => 'callback_html'
		);

		// Reply parent topic id (If no parent, then 0)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'starter',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_parent',
			'callback_method' => 'callback_topicid'
		);

		// Reply dates.
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_date',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_date_gmt',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_modified',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[]	 = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'reply',
			'to_fieldname'    => 'post_modified_gmt',
			'callback_method' => 'callback_datetime'
		);

		/** Comment Section *****************************************************/

		// Comment id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'node',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'comment',
			'to_fieldname'    => '_bbp_vb5_comment_post_id'
		);

		// Comment id (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'nodeid',
			'to_type'         => 'comment',
			'to_fieldname'    => '_bbp_post_id'
		);

		// Comment parent forum id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'forum',
			'from_fieldname'  => 'parentid',
			'from_expression' => 'LEFT JOIN `node` AS `reply` ON reply.nodeid = node.nodeid
								  LEFT JOIN `node` AS `topic` ON reply.parentid = topic.nodeid
								  LEFT JOIN `node` AS `forum` ON topic.parentid = forum.nodeid',
			'to_type'         => 'comment',
			'to_fieldname'    => '_bbp_forum_id',
			'callback_method' => 'callback_forumid'
		);

		// Comment parent topic id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'starter',
			'to_type'         => 'comment',
			'to_fieldname'    => '_bbp_topic_id',
			'callback_method' => 'callback_topicid'
		);

		// Comment parent reply id (If no parent, then 0. Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'parentid',
			'to_type'         => 'comment',
			'to_fieldname'    => '_bbp_reply_to'
		);

		// Comment author ip (Stored in postmeta)
		$this->field_map[] = array(
			'from_tablename' => 'reply',
			'from_fieldname' => 'ipaddress',
			'to_type'        => 'comment',
			'to_fieldname'   => '_bbp_author_ip'
		);

		// Comment author.
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'userid',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_author',
			'callback_method' => 'callback_userid'
		);

		// Comment title.
		$this->field_map[] = array(
			'from_tablename'  => 'forum',
			'from_fieldname'  => 'title',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_title',
			'callback_method' => 'callback_reply_title'
		);

		// Comment slug (Clean name to avoid conflicts)
		$this->field_map[] = array(
			'from_tablename'  => 'forum',
			'from_fieldname'  => 'urlident',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_title',
			'callback_method' => 'callback_slug'
		);

		// Comment content.
		// Note: We join the 'text' table because 'node' table does not include reply content.
		$this->field_map[] = array(
			'from_tablename'  => 'text',
			'from_fieldname'  => 'rawtext',
			'join_tablename'  => 'node',
			'join_type'       => 'INNER',
			'join_expression' => 'ON text.nodeid = reply.nodeid
									WHERE reply.contenttypeid =22
									AND reply.urlident IS NULL
									AND reply.title IS NULL',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_content',
			'callback_method' => 'callback_html'
		);

		// Comment parent topic id (If no parent, then 0)
		$this->field_map[] = array(
			'from_tablename'  => 'topic',
			'from_fieldname'  => 'starter',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_parent',
			'callback_method' => 'callback_topicid'
		);

		// Comment dates.
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_date',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_date_gmt',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[] = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_modified',
			'callback_method' => 'callback_datetime'
		);
		$this->field_map[]	 = array(
			'from_tablename'  => 'reply',
			'from_fieldname'  => 'publishdate',
			'to_type'         => 'comment',
			'to_fieldname'    => 'post_modified_gmt',
			'callback_method' => 'callback_datetime'
		);

		/** User Section ******************************************************/

		// Store old User id (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'userid',
			'to_type'        => 'user',
			'to_fieldname'   => '_bbp_user_id'
		);

		// Store old User password (Stored in usermeta serialized with salt)
		$this->field_map[] = array(
			'from_tablename'  => 'user',
			'from_fieldname'  => 'password',
			'to_type'         => 'user',
			'to_fieldname'    => '_bbp_password',
			'callback_method' => 'callback_savepass'
		);

		// Store old User Salt (This is only used for the SELECT row info for the above password save)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'salt',
			'to_type'        => 'user',
			'to_fieldname'   => ''
		);

		// User password verify class (Stored in usermeta for verifying password)
		$this->field_map[] = array(
			'to_type'      => 'user',
			'to_fieldname' => '_bbp_class',
			'default'      => 'vBulletin5'
		);

		// User name.
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'username',
			'to_type'        => 'user',
			'to_fieldname'   => 'user_login'
		);

		// User email.
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'email',
			'to_type'        => 'user',
			'to_fieldname'   => 'user_email'
		);

		// User homepage.
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'homepage',
			'to_type'        => 'user',
			'to_fieldname'   => 'user_url'
		);

		// User registered.
		$this->field_map[] = array(
			'from_tablename'  => 'user',
			'from_fieldname'  => 'joindate',
			'to_type'         => 'user',
			'to_fieldname'    => 'user_registered',
			'callback_method' => 'callback_datetime'
		);

		// User AIM (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'aim',
			'to_type'        => 'user',
			'to_fieldname'   => 'aim'
		);

		// User Yahoo (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'yahoo',
			'to_type'        => 'user',
			'to_fieldname'   => 'yim'
		);

		// User ICQ (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'icq',
			'to_type'        => 'user',
			'to_fieldname'   => '_bbp_vbulletin5_user_icq'
		);

		// User MSN (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'msn',
			'to_type'        => 'user',
			'to_fieldname'   => '_bbp_vbulletin5_user_msn'
		);

		// User Skype (Stored in usermeta)
		$this->field_map[] = array(
			'from_tablename' => 'user',
			'from_fieldname' => 'skype',
			'to_type'        => 'user',
			'to_fieldname'   => '_bbp_vbulletin5_user_skype'
		);
	}

	/**
	 * This method allows us to indicates what is or is not converted for each
	 * converter.
	 */
	public function info() {
		return '';
	}


	/**
	 * This method is to save the salt and password together.  That
	 * way when we authenticate it we can get it out of the database
	 * as one value. Array values are auto sanitized by WordPress.
	 */
	public function callback_savepass( $field, $row ) {
		$pass_array = array( 'hash'	 => $field, 'salt'	 => $row['salt'] );
		return $pass_array;
	}

	/**
	 * This method is to take the pass out of the database and compare
	 * to a pass the user has typed in.
	 *
	 * vBulletin v5.x passwords do not work. Maybe use the below plugin's approach?
	 *
	 * @link http://wordpress.org/extend/plugins/vb-user-copy/
	 * @link http://plugins.trac.wordpress.org/browser/vb-user-copy/trunk/vb_user_copy.php
	 */
	public function authenticate_pass( $password, $serialized_pass ) {
		$pass_array = unserialize( $serialized_pass );
		return ( $pass_array['hash'] == md5( md5( $password ) . $pass_array['salt'] ) );
	}

	/**
	 * Verify the topic reply count.
	 *
	 * @param int $count vBulletin v5.x reply count
	 * @return string WordPress safe
	 */
	public function callback_topic_reply_count( $count = 1 ) {
		$count = absint( (int) $count - 1 );
		return $count;
	}

	/**
	 * Set the reply title
	 *
	 * @param string $title PHPFox v3.5.x topic title of this reply
	 * @return string Prefixed topic title, or empty string
	 */
	public function callback_reply_title( $title = '' ) {
		$title = !empty( $title ) ? __( 'Re: ', 'bbpress' ) . html_entity_decode( $title ) : '';
		return $title;
	}

	/**
	 * Translate the post status from vBulletin v5.x numeric's to WordPress's strings.
	 *
	 * @param int $status vBulletin v5.x numeric topic status
	 * @return string WordPress safe
	 */
	public function callback_topic_status( $status = 1 ) {
		switch ( $status ) {
			case 0 :
				$status = 'closed';
				break;

			case 1  :
			default :
				$status = 'publish';
				break;
		}
		return $status;
	}

	/**
	 * This callback processes any custom parser.php attributes and custom code with preg_replace
	 */
	protected function callback_html( $field ) {

		// Strips vBulletin v5.x custom HTML first from $field before parsing $field to parser.php
		$vbulletin_markup = $field;
		$vbulletin_markup = html_entity_decode( $vbulletin_markup );

		// Replace '[QUOTE]' with '<blockquote>'
		$vbulletin_markup = preg_replace( '/\[QUOTE\]/', '<blockquote>', $vbulletin_markup );
		// Replace '[QUOTE=User Name($1);PostID($2)]' with '<em>@$1 $2 wrote:</em><blockquote>"
		$vbulletin_markup = preg_replace( '/\[QUOTE=(.*?);(.*?)\]/' , '<em>@$1 $2 wrote:</em><blockquote>', $vbulletin_markup );
		// Replace '[/QUOTE]' with '</blockquote>'
		$vbulletin_markup = preg_replace( '/\[\/QUOTE\]/', '</blockquote>', $vbulletin_markup );
		// Replace '[MENTION=###($1)]User Name($2)[/MENTION]' with '@$2"
		$vbulletin_markup = preg_replace( '/\[MENTION=(.*?)\](.*?)\[\/MENTION\]/', '@$2', $vbulletin_markup );

		// Replace '[video=youtube;$1]$2[/video]' with '$2"
		$vbulletin_markup = preg_replace( '/\[video\=youtube;(.*?)\](.*?)\[\/video\]/', '$2', $vbulletin_markup );

		// Now that vBulletin v5.x custom HTML has been stripped put the cleaned HTML back in $field
		$field = $vbulletin_markup;

		// Parse out any bbCodes in $field with the BBCode 'parser.php'
		require_once( bbpress()->admin->admin_dir . 'parser.php' );
		$bbcode = BBCode::getInstance();
		$bbcode->enable_smileys = false;
		$bbcode->smiley_regex   = false;
		return html_entity_decode( $bbcode->Parse( $field ) );
	}

}
